/*
 * @(#)CERApplicationModel.java  1.0  2006-06-18
 *
 * Copyright (c) 2006 Werner Randelshofer
 * Staldenmattweg 2, CH-6405 Immensee, Switzerland
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * Werner Randelshofer. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Werner Randelshofer.
 */
package ch.hslu.cm.cer;

import ch.hslu.cm.cer.diagram.CERAttributeConnectionTool;
import ch.hslu.cm.cer.diagram.CERAttributeFigure;
import ch.hslu.cm.cer.diagram.CERConnectionFigure;
import ch.hslu.cm.cer.diagram.CEREntitySetFigure;
import ch.hslu.cm.cer.diagram.CERGeneralizationConnectionTool;
import ch.hslu.cm.cer.diagram.CERISAFigure;
import ch.hslu.cm.cer.diagram.CERRelationshipConnectionTool;
import ch.hslu.cm.cer.diagram.CERRelationshipSetFigure;
import ch.hslu.cm.cer.diagram.ConceptualERDiagram;
import ch.hslu.cm.cer.model.*;
import ch.randelshofer.html.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.DefaultApplicationModel;
import org.jhotdraw.app.MenuBuilder;
import org.jhotdraw.app.View;
import org.jhotdraw.app.action.ActionUtil;
import org.jhotdraw.app.action.file.ExportFileAction;
import org.jhotdraw.app.action.view.ToggleViewPropertyAction;
import org.jhotdraw.app.action.view.ViewPropertyAction;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.DefaultDrawingEditor;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.TextAreaFigure;
import org.jhotdraw.draw.action.ButtonFactory;
import org.jhotdraw.draw.tool.ConnectionTool;
import org.jhotdraw.draw.tool.CreationTool;
import org.jhotdraw.draw.tool.TextAreaCreationTool;
import org.jhotdraw.draw.tool.Tool;
import org.jhotdraw.gui.Arrangeable;
import org.jhotdraw.gui.JFileURIChooser;
import org.jhotdraw.gui.URIChooser;
import org.jhotdraw.gui.filechooser.ExtensionFileFilter;
import org.jhotdraw.util.ResourceBundleUtil;

/**
 * CERApplicationModel.
 *
 * @author Werner Randelshofer.
 * @version 1.0 2006-06-18 Created.
 */
public class CERApplicationModel extends DefaultApplicationModel {

    /* private*/ final static double[] scaleFactors = {5, 4, 3, 2, 1.5, 1.25, 1, 0.75, 0.5, 0.25, 0.10};

    private static class ToolButtonListener implements ItemListener {

        private Tool tool;
        private DrawingEditor editor;

        public ToolButtonListener(Tool t, DrawingEditor editor) {
            this.tool = t;
            this.editor = editor;
        }

        @Override
        public void itemStateChanged(ItemEvent evt) {
            if (evt.getStateChange() == ItemEvent.SELECTED) {
                editor.setTool(tool);
            }
        }
    }
    /**
     * This editor is shared by all projects.
     */
    private DefaultDrawingEditor sharedEditor;
    private HashMap<String, Action> actions;

    /** Creates a new instance. */
    public CERApplicationModel() {
    }

    @Override
    public ActionMap createActionMap(Application a, View v) {
        ResourceBundleUtil cerLabels = ResourceBundleUtil.getBundle("ch.hslu.cm.cer.Labels");
        ResourceBundleUtil cmLabels = ResourceBundleUtil.getBundle("ch.hslu.cm.Labels");
        AbstractAction aa;
        ActionMap am = super.createActionMap(a, v);


        am.put(ExportFileAction.ID, new ExportFileAction(a, v));
        am.put(CompareCERModelsAction.ID, new CompareCERModelsAction(a, v));
        am.put("toggleOptionsPanel", aa = new ToggleViewPropertyAction(a, v, "optionsVisible"));
        cmLabels.configureAction(aa, "options");
        am.put("toggleGrid", aa = new ToggleViewPropertyAction(a, v, "gridVisible"));
        cmLabels.configureAction(aa, "view.grid");
        am.put("pArrangeHorizontal", aa = new ViewPropertyAction(a, v, "arrangement", Arrangeable.Arrangement.HORIZONTAL));
        cmLabels.configureAction(aa, "view.arrangeHorizontal");
        am.put("pArrangeVertical", aa = new ViewPropertyAction(a,
                v, "arrangement", Arrangeable.Arrangement.VERTICAL));
        cmLabels.configureAction(aa, "view.arrangeVertical");
        am.put("pArrangeCascade", aa = new ViewPropertyAction(a, v, "arrangement", Arrangeable.Arrangement.CASCADE));
        cmLabels.configureAction(aa, "view.arrangeOverlap");
        for (double sf : scaleFactors) {
            am.put((int) (sf * 100) + "%",
                    aa = new ViewPropertyAction(a, v, "scaleFactor", Double.TYPE, new Double(sf)));
            aa.putValue(Action.NAME, (int) (sf * 100) + " %");

        }
        return am;
    }

    public DefaultDrawingEditor getSharedEditor() {
        if (sharedEditor == null) {
            sharedEditor = new DefaultDrawingEditor();
        }
        return sharedEditor;
    }

    @Override
    public void initView(Application a, View p) {
        if (a.isSharingToolsAmongViews()) {
            ((CERView) p).setDrawingEditor(getSharedEditor());
        }
    }

    private void addCreationButtonsTo(JToolBar tb, final DrawingEditor editor) {
        // AttributeKeys for the entitie sets
        HashMap<AttributeKey, Object> attributes;
        attributes = new HashMap<AttributeKey, Object>();
        attributes.put(AttributeKeys.FILL_COLOR, ConceptualERDiagram.ENTITY_SET_FILL_COLOR);
        attributes.put(AttributeKeys.STROKE_COLOR, ConceptualERDiagram.ENTITY_SET_STROKE_COLOR);
        attributes.put(AttributeKeys.TEXT_COLOR, ConceptualERDiagram.ENTITY_SET_TEXT_COLOR);

        ResourceBundleUtil cerLabels = ResourceBundleUtil.getBundle("ch.hslu.cm.cer.Labels");
        ResourceBundleUtil drawLabels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");

        ButtonFactory.addSelectionToolTo(tb, editor);
        tb.addSeparator();

        CEREntitySetFigure esf;
        CERRelationshipSetFigure rsf;

        ButtonFactory.addToolTo(tb, editor, new CreationTool(new CEREntitySetFigure(), attributes), "edit.createEntitySetStrong", cerLabels);
        ButtonFactory.addToolTo(tb, editor, new CreationTool(esf = new CEREntitySetFigure(), attributes), "edit.createEntitySetWeak", cerLabels);
        esf.getModel().setType(CEREntitySet.TYPE_WEAK);
        ButtonFactory.addToolTo(tb, editor, new CreationTool(new CERRelationshipSetFigure(), attributes), "edit.createRelationshipSetStrong", cerLabels);
        ButtonFactory.addToolTo(tb, editor, new CreationTool(rsf = new CERRelationshipSetFigure(), attributes), "edit.createRelationshipSetIdentifying", cerLabels);
        rsf.getModel().setType(CEREntitySet.TYPE_WEAK);
        ButtonFactory.addToolTo(tb, editor, new CreationTool(new CERISAFigure(), attributes), "edit.createISA", cerLabels);
        ButtonFactory.addToolTo(tb, editor, new CreationTool(new CERAttributeFigure(), attributes), "edit.createAttribute", cerLabels);
        tb.addSeparator();
        ButtonFactory.addToolTo(tb, editor, new ConnectionTool(new CERConnectionFigure(), attributes), "edit.createConnection", cerLabels);
        ButtonFactory.addToolTo(tb, editor, new CERRelationshipConnectionTool(new CERConnectionFigure(), attributes), "edit.createRelationshipMM", cerLabels);
        ButtonFactory.addToolTo(tb, editor, new CERRelationshipConnectionTool(new CERConnectionFigure(1), attributes), "edit.createRelationship11", cerLabels);
        ButtonFactory.addToolTo(tb, editor, new CERGeneralizationConnectionTool(new CERConnectionFigure(), attributes), "edit.createGeneralization", cerLabels);
        ButtonFactory.addToolTo(tb, editor, new CERAttributeConnectionTool(new CERConnectionFigure(), attributes), "edit.createAttributeLink", cerLabels);
        tb.addSeparator();
        ButtonFactory.addToolTo(tb, editor, new TextAreaCreationTool(new TextAreaFigure()), "edit.createTextArea", drawLabels);

    }

    /**
     * Creates toolbars for the application.
     * This class always returns an empty list. Subclasses may return other
     * values.
     */
    @Override
    public List<JToolBar> createToolBars(Application a, View pr) {
        ResourceBundleUtil drawLabels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        ResourceBundleUtil cerLabels = ResourceBundleUtil.getBundle("ch.hslu.cm.cer.Labels");
        CERView p = (CERView) pr;

        DrawingEditor editor;
        if (p == null) {
            editor = getSharedEditor();
        } else {
            editor = p.getDrawingEditor();
        }

        LinkedList<JToolBar> list = new LinkedList<JToolBar>();
        JToolBar tb;
        tb = new JToolBar();
        addCreationButtonsTo(tb, editor);
        tb.setName(drawLabels.getString("window.drawToolBar.title"));
        list.add(tb);
        tb = new JToolBar();
        ButtonFactory.addAttributesButtonsTo(tb, editor);
        tb.setName(drawLabels.getString("window.attributesToolBar.title"));
        list.add(tb);
        tb = new JToolBar();
        ButtonFactory.addAlignmentButtonsTo(tb, editor);
        tb.setName(drawLabels.getString("window.alignmentToolBar.title"));
        list.add(tb);
        tb = new JToolBar(cerLabels.getString("toolBarHTML"));
        HTMLToolBarFactory.addHTMLButtonsTo(tb);
        list.add(tb);
        return list;
    }

    @Override
    protected MenuBuilder createMenuBuilder() {
        CERMenuBuilder mb = new CERMenuBuilder();
        mb.setSuppressIcons(true);
        return mb;
    }

    @Override
    public URIChooser createOpenChooser(Application a, View v) {
        JFileURIChooser c = new JFileURIChooser();
        c.addChoosableFileFilter(new ExtensionFileFilter("Drawing .xml", "xml"));
        return c;
    }

    @Override
    public URIChooser createSaveChooser(Application a, View v) {
        JFileURIChooser c = new JFileURIChooser();
        c.addChoosableFileFilter(new ExtensionFileFilter("Drawing .xml", "xml"));
        return c;
    }

    @Override
    public URIChooser createExportChooser(Application a, View v) {
        JFileURIChooser c = new JFileURIChooser();
        c.addChoosableFileFilter(new ExtensionFileFilter("HTML .html", "html"));
        return c;
    }
}
